﻿var dvbIdArray = ["patInterval", "pmtInterval", "nitcInterval", "nitoInterval", "sdtcInterval", "sdtoInterval", "batInterval", "catInterval"];
var DVB_NUM = 8;

var atscIdArray = ["patInterval", "pmtInterval", "catInterval", "vctInterval", "mgtInterval", "sttInterval"];
var ATSC_NUM = 6;

var dvbDefaultValue = [100, 100, 1000, 1000, 300, 300, 1000, 300];
var atscDefaultValue = [100, 400, 0, 350, 150, 0];

var NITC = 3;
var VCT = 8;
var ROW_NUM_ALL = 11;

var objIdArray = [dvbIdArray, atscIdArray];
var ROW_NUM = [DVB_NUM, ATSC_NUM];

var id;
var identifyData;
var DVB = 0;
var ATSC = 1;
var udpPos;

$(document).ready(function()
{
	var group;
	var userName;
	var mainIpAddr;
	var args = GetArgs();
	id = args["ID"];
	group = args["group"];
	userName = args["userName"];
	mainIpAddr = args["mainIpAddr"];
	if(language == CHINESE)
	{
		var breadCrumbText = encodeURIComponent("PSI/SI间隔", "utf-8");
	}
	else
	{
		var breadCrumbText = encodeURIComponent("PSI/SI Interval", "utf-8");
	}
	$("#transferFrame").attr("src", "http://" + mainIpAddr + "/asp/transfer.asp?group=" + group + "&userName=" + userName +"&information=" + breadCrumbText);
	funcUpdateDisplay();
	$("#setZreoBtn").click(function()
	{
		for(i = 0; i < ROW_NUM[identifyData]; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(0);
		}
		EnableButton("applyBtn");
	});
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("defaultBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	EnableButton("refreshBtn");
	EnableButton("defaultBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + PSI_INTERVAL + "&cmd=" + GET + "&id=" + id + "&language=" + language + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				if(identifyData == DVB)
				{
					for(var i = NITC; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
				}
				else
				{
					for(var i = NITC; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
				}
				for(var i = 0; i < ROW_NUM[identifyData]; i++)
				{
					$("#" + objIdArray[identifyData][i]).val(data[i]);
				}
			    refreshFlag = true;
			}			
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PSI_INTERVAL + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				if(language == ENGLISH)
				{
					alert("Set Successfully!");
				}
				else
				{
					alert("设置成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			//GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var rowData;
	var data;
	for(var i = 0; i < ROW_NUM[identifyData]; i++)
	{
		rowData =  $("#" + objIdArray[identifyData][i]).val();
		if(i == 0)
		{
			data = rowData;
		}
		else
		{
			data += FIRST_DELIMITER + rowData;
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;

	returnFlag = ValidateParam($("#patInterval"), "INT_DEC", 0, 1000, "<PAT Interval>", "<PAT发表间隔>", language);
	if(returnFlag == false)
	{
		return false;
	}		

	returnFlag = ValidateParam($("#pmtInterval"), "INT_DEC", 0, 1000, "<PMT Interval>", "<PMT发表间隔>", language);
	if(returnFlag == false)
	{
		return false;
	}		

	returnFlag = ValidateParam($("#catInterval"), "INT_DEC", 0, 1000, "<CAT Interval>", "<CAT发表间隔>", language);
	if(returnFlag == false)
	{
		return false;
	}		

	if(identifyData == DVB)
	{
		returnFlag = ValidateParam($("#nitcInterval"), "INT_DEC", 0, 1000, "<NIT(Actual) Interval>", "<NIT(当前)发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#nitoInterval"), "INT_DEC", 0, 1000, "<NIT(others) Interval>", "<NIT(其他)发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#sdtcInterval"), "INT_DEC", 0, 1000, "<SDT(Actual) Interval>", "<SDT(当前)发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#sdtoInterval"), "INT_DEC", 0, 1000, "<SDT(others) Interval>", "<SDT(其他)发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#batInterval"), "INT_DEC", 0, 1000, "<BAT Interval>", "<BAT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	else
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][3]), "INT_DEC", 0, 1000, "<VCT Interval>", "<VCT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#" + objIdArray[identifyData][4]), "INT_DEC", 0, 1000, "<MGT Interval>", "<MGT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}		

		returnFlag = ValidateParam($("#" + objIdArray[identifyData][5]), "INT_DEC", 0, 1000, "<STT Interval>", "<STT发表间隔>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}

function resetInterval()
{
	var i;
	
	if(identifyData == DVB)
	{
		for(i = 0; i < ROW_NUM[identifyData]; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(dvbDefaultValue[i]);
		}
	}
	else
	{
		for(i = 0; i < ROW_NUM[identifyData]; i++)
		{
			$("#" + objIdArray[identifyData][i]).val(atscDefaultValue[i]);
		}
	}
	EnableButton("applyBtn");
}